<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_pricing', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->decimal('price', 10, 2)->default(0.00); // Price with 2 decimal places (0.00 = free)
            $table->string('currency', 3)->default('USD'); // ISO currency code
            $table->boolean('is_active')->default(true);
            $table->text('description')->nullable(); // Optional pricing description
            $table->timestamps();
            
            // Ensure only one active pricing per template
            $table->unique(['template_id', 'is_active']);
            $table->index(['template_id', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_pricing');
    }
};