<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, temporarily change all SERQ questions to brain_frames
        DB::table('paradigm_questions')
            ->where('assessment_module', 'serq')
            ->update(['assessment_module' => 'brain_frames']);

        // Now update the ENUM
        DB::statement("ALTER TABLE paradigm_questions MODIFY COLUMN assessment_module ENUM('conflict_styles','connection_styles','personality_blueprint','brain_frames','brain_fields','social_intelligence','emotional_intelligence','relevancy_quotient') NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert the ENUM back to original values
        DB::statement("ALTER TABLE paradigm_questions MODIFY COLUMN assessment_module ENUM('balance_profile','conflict_styles','connection_styles','personality_blueprint','serq','brain_frames','brain_fields') NOT NULL");
    }
};
