<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_pdf_pages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->integer('page_number');
            $table->string('page_title')->nullable();
            $table->string('background_image_path', 500)->nullable();
            $table->boolean('is_content_page')->default(true); // true = has elements, false = image only
            $table->json('page_settings')->nullable(); // Additional page settings
            $table->integer('display_order')->default(0);
            $table->timestamps();
            
            $table->index(['template_id', 'page_number']);
            $table->unique(['template_id', 'page_number']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_pdf_pages');
    }
};