<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_badge_titles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('paradigm_form_templates')->onDelete('cascade');
            $table->string('type_code', 50); // Paradigm type codes (e.g., "LU Dominant", "Balanced Quadrant", etc.)
            $table->string('badge_title', 255);
            $table->text('description')->nullable();
            $table->timestamps();
            
            $table->unique(['template_id', 'type_code']);
            $table->index(['template_id', 'type_code']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_badge_titles');
    }
};