<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('branches', function (Blueprint $table) {
            $table->enum('verification_status', ['pending', 'approved', 'rejected'])->default('approved')->after('created_by');
            $table->unsignedBigInteger('verified_by')->nullable()->after('verification_status');
            $table->timestamp('verified_at')->nullable()->after('verified_by');
            $table->text('rejection_reason')->nullable()->after('verified_at');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->enum('staff_verification_status', ['pending', 'approved', 'rejected'])->nullable()->after('category_id');
            $table->unsignedBigInteger('staff_verified_by')->nullable()->after('staff_verification_status');
            $table->timestamp('staff_verified_at')->nullable()->after('staff_verified_by');
            $table->text('staff_rejection_reason')->nullable()->after('staff_verified_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('branches', function (Blueprint $table) {
            $table->dropColumn(['verification_status', 'verified_by', 'verified_at', 'rejection_reason']);
        });

        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['staff_verification_status', 'staff_verified_by', 'staff_verified_at', 'staff_rejection_reason']);
        });
    }
};

