<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_practitioner_transfers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('marketplace_purchase_id')->constrained('paradigm_marketplace_purchases')->onDelete('cascade');
            $table->foreignId('from_practitioner_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('to_practitioner_id')->constrained('users')->onDelete('cascade');
            $table->decimal('transfer_price', 10, 2);
            $table->enum('transfer_status', ['pending', 'completed', 'cancelled'])->default('pending');
            $table->unsignedBigInteger('wallet_transaction_id_from')->nullable();
            $table->unsignedBigInteger('wallet_transaction_id_to')->nullable();
            $table->timestamp('transferred_at')->nullable();
            $table->timestamps();
            
            $table->foreign('wallet_transaction_id_from', 'ppt_wallet_from_fk')->references('id')->on('wallet_history')->onDelete('set null');
            $table->foreign('wallet_transaction_id_to', 'ppt_wallet_to_fk')->references('id')->on('wallet_history')->onDelete('set null');
            
            $table->index('marketplace_purchase_id');
            $table->index('from_practitioner_id');
            $table->index('to_practitioner_id');
            $table->index('transfer_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_practitioner_transfers');
    }
};

