<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_link_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('result_id')->constrained('paradigm_assessment_results')->onDelete('cascade');
            $table->foreignId('marketplace_purchase_id')->constrained('paradigm_marketplace_purchases')->onDelete('cascade');
            $table->foreignId('practitioner_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('client_id')->constrained('users')->onDelete('cascade');
            $table->enum('status', ['pending', 'accepted', 'declined'])->default('pending');
            $table->timestamp('requested_at');
            $table->timestamp('responded_at')->nullable();
            $table->timestamps();
            
            $table->index('result_id');
            $table->index('marketplace_purchase_id');
            $table->index('practitioner_id');
            $table->index('client_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_link_requests');
    }
};

