<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paradigm_marketplace_purchases', function (Blueprint $table) {
            $table->id();
            $table->foreignId('result_id')->constrained('paradigm_assessment_results')->onDelete('cascade');
            $table->foreignId('purchaser_id')->constrained('users')->onDelete('cascade');
            $table->decimal('purchase_price', 10, 2);
            $table->timestamp('purchased_at');
            $table->unsignedBigInteger('wallet_transaction_id')->nullable();
            $table->boolean('is_sold')->default(true);
            $table->foreignId('linked_practitioner_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
            
            $table->foreign('wallet_transaction_id', 'pmp_wallet_fk')->references('id')->on('wallet_history')->onDelete('set null');
            
            $table->index('result_id');
            $table->index('purchaser_id');
            $table->index('linked_practitioner_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paradigm_marketplace_purchases');
    }
};

