<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Paddle Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for Paddle Billing API integration
    | Documentation: https://developer.paddle.com/
    |
    */

    'vendor_id' => env('PADDLE_VENDOR_ID'),
    'api_key' => env('PADDLE_API_KEY'),
    'webhook_secret' => env('PADDLE_WEBHOOK_SECRET'),
    'environment' => env('PADDLE_ENVIRONMENT', 'live'), // 'live' or 'sandbox'
    
    /*
    |--------------------------------------------------------------------------
    | Wallet Top-up Price ID
    |--------------------------------------------------------------------------
    |
    | Create ONE product in Paddle at $1 USD
    | System uses quantity to handle any amount:
    |   - User enters $50 → Orders 50 units × $1 = $50
    |   - User enters $75 → Orders 75 units × $1 = $75
    |   - User enters $133 → Orders 133 units × $1 = $133
    |
    | This allows users to enter any custom amount from $50 minimum.
    |
    */
    'wallet_price_id' => env('PADDLE_WALLET_PRICE_ID_DEFAULT'),
    
    /*
    |--------------------------------------------------------------------------
    | Subscription Price IDs
    |--------------------------------------------------------------------------
    |
    | Configure price IDs for subscription plans.
    | These must be created in your Paddle dashboard first.
    |
    */
    'subscription_price_ids' => [
        'basic' => env('PADDLE_SUBSCRIPTION_PRICE_ID_BASIC'),
        'standard' => env('PADDLE_SUBSCRIPTION_PRICE_ID_STANDARD'),
        'premium' => env('PADDLE_SUBSCRIPTION_PRICE_ID_PREMIUM'),
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Webhook Configuration
    |--------------------------------------------------------------------------
    |
    | Webhook endpoints that Paddle will call.
    | Set these URLs in your Paddle dashboard:
    | - Wallet: https://yourdomain.com/api/paddle/webhook/wallet
    | - Subscription: https://yourdomain.com/api/paddle/webhook/subscription
    |
    */
    'webhook_endpoints' => [
        'wallet' => '/api/paddle/webhook/wallet',
        'subscription' => '/api/paddle/webhook/subscription',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Supported Currencies
    |--------------------------------------------------------------------------
    |
    | Paddle supports 30+ currencies automatically.
    | The system will use the default currency from your GlobalSettings.
    | Paddle will handle currency conversion and display prices in 
    | the customer's local currency automatically.
    |
    | Supported: USD, EUR, GBP, CAD, AUD, JPY, CNY, INR, BRL, and more
    |
    */
    'currencies' => [
        'USD', 'EUR', 'GBP', 'CAD', 'AUD', 'NZD', 'JPY', 'CNY', 'HKD', 'SGD',
        'INR', 'BRL', 'MXN', 'ARS', 'CLP', 'COP', 'PEN', 'ZAR', 'THB', 'PHP',
        'IDR', 'MYR', 'VND', 'KRW', 'TWD', 'TRY', 'PLN', 'CZK', 'DKK', 'SEK',
        'NOK', 'CHF', 'RUB', 'UAH', 'ILS', 'SAR', 'AED', 'EGP', 'NGN', 'KES',
    ],
];
