<?php

namespace App\Support;

use App\Services\ParadigmShortcodeService;

class Shortcode
{
    /**
     * Process all shortcodes in content
     */
    public static function process(string $content): string
    {
        // Process Paradigm Profile shortcodes
        $content = self::processParadigmShortcodes($content);
        
        // Add other shortcode processors here as needed
        
        return $content;
    }
    
    /**
     * Process Paradigm Profile shortcodes
     */
    private static function processParadigmShortcodes(string $content): string
    {
        // Pattern to match [paradigm_form id="1"] shortcodes
        $pattern = '/\[paradigm_form\s+([^\]]+)\]/';
        
        return preg_replace_callback($pattern, function($matches) {
            // Parse attributes from shortcode
            $attributes = [];
            if (preg_match_all('/(\w+)="([^"]*)"/', $matches[1], $attrMatches, PREG_SET_ORDER)) {
                foreach ($attrMatches as $attr) {
                    $attributes[$attr[1]] = $attr[2];
                }
            }
            
            $shortcodeService = new ParadigmShortcodeService();
            return $shortcodeService->processShortcode($attributes);
        }, $content);
    }
}
