<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StaffDocument extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'staff_id',
        'document_type',
        'file_name',
        'file_path',
        'file_size',
        'uploaded_by',
    ];

    /**
     * Get the staff user that owns the document.
     */
    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    /**
     * Get the user who uploaded the document.
     */
    public function uploader()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
}

