<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ParadigmPricing extends Model
{
    use HasFactory;

    protected $table = 'paradigm_pricing';

    protected $fillable = [
        'template_id',
        'price',
        'currency',
        'is_active',
        'description'
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'is_active' => 'boolean'
    ];

    /**
     * Get the template that owns the pricing
     */
    public function template(): BelongsTo
    {
        return $this->belongsTo(ParadigmFormTemplate::class, 'template_id');
    }

    /**
     * Check if this pricing is free
     */
    public function isFree(): bool
    {
        return $this->price == 0.00;
    }

    /**
     * Get active pricing for a template
     */
    public static function getActivePricingForTemplate(int $templateId): ?self
    {
        return self::where('template_id', $templateId)
                   ->where('is_active', true)
                   ->first();
    }
}