<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ParadigmLinkRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'result_id',
        'marketplace_purchase_id',
        'practitioner_id',
        'client_id',
        'status',
        'requested_at',
        'responded_at',
    ];

    protected $casts = [
        'requested_at' => 'datetime',
        'responded_at' => 'datetime',
    ];

    /**
     * Get the assessment result
     */
    public function result(): BelongsTo
    {
        return $this->belongsTo(ParadigmAssessmentResult::class, 'result_id');
    }

    /**
     * Get the marketplace purchase
     */
    public function marketplacePurchase(): BelongsTo
    {
        return $this->belongsTo(ParadigmMarketplacePurchase::class, 'marketplace_purchase_id');
    }

    /**
     * Get the practitioner
     */
    public function practitioner(): BelongsTo
    {
        return $this->belongsTo(User::class, 'practitioner_id');
    }

    /**
     * Get the client
     */
    public function client(): BelongsTo
    {
        return $this->belongsTo(User::class, 'client_id');
    }

    /**
     * Accept link request
     */
    public function accept(): void
    {
        $this->update([
            'status' => 'accepted',
            'responded_at' => now(),
        ]);
    }

    /**
     * Decline link request
     */
    public function decline(): void
    {
        $this->update([
            'status' => 'declined',
            'responded_at' => now(),
        ]);
    }
}

