<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CreditPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'credits',
        'base_price_zar',
        'final_price_zar',
        'usd_equivalent',
        'discount_percentage',
        'discount_amount_zar',
        'is_active',
        'is_paradigm_package',
        'sort_order'
    ];

    protected $casts = [
        'base_price_zar' => 'decimal:2',
        'final_price_zar' => 'decimal:2',
        'usd_equivalent' => 'decimal:2',
        'discount_amount_zar' => 'decimal:2',
        'is_active' => 'boolean',
        'is_paradigm_package' => 'boolean'
    ];

    /**
     * Get formatted price in ZAR
     */
    public function getFormattedPriceZarAttribute()
    {
        return 'R' . number_format($this->final_price_zar, 2);
    }

    /**
     * Get formatted discount amount
     */
    public function getFormattedDiscountAmountAttribute()
    {
        return 'R' . number_format($this->discount_amount_zar, 2);
    }

    /**
     * Get formatted USD equivalent
     */
    public function getFormattedUsdEquivalentAttribute()
    {
        return '$' . number_format($this->usd_equivalent, 2);
    }

    /**
     * Scope for active packages
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope for ordering by sort_order
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order', 'asc');
    }
}