<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BranchDocument extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'branch_id',
        'document_type',
        'file_name',
        'file_path',
        'file_size',
        'uploaded_by',
    ];

    /**
     * Get the branch that owns the document.
     */
    public function branch()
    {
        return $this->belongsTo(Branches::class, 'branch_id');
    }

    /**
     * Get the user who uploaded the document.
     */
    public function uploader()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
}

