<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckStaffVerification
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();
        
        // Check if user is staff (user_type = 4)
        if ($user && $user->user_type == 4) {
            // Check verification status
            if ($user->staff_verification_status !== 'approved') {
                $status = $user->staff_verification_status ?? 'pending';
                $message = match ($status) {
                    'pending' => 'Your account is pending verification. Please wait for admin approval.',
                    'rejected' => 'Your account verification was rejected. Reason: ' . ($user->staff_rejection_reason ?? 'Not specified'),
                    default => 'Your account is not yet verified. Please contact admin.',
                };
                
                return redirect()->route('login')->with('error', $message);
            }
        }
        
        return $next($request);
    }
}

