<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use App\Services\ParadigmShortcodeService;
use Illuminate\Http\Request;

class ParadigmShortcodeController extends Controller
{
    protected ParadigmShortcodeService $shortcodeService;
    
    public function __construct(ParadigmShortcodeService $shortcodeService)
    {
        $this->shortcodeService = $shortcodeService;
    }
    
    /**
     * Handle Paradigm Profile shortcode rendering
     */
    public function handleShortcode(Request $request)
    {
        $attributes = $request->all();
        
        return $this->shortcodeService->processShortcode($attributes);
    }
    
    /**
     * Process shortcode from content
     */
    public function processContent(string $content): string
    {
        // Pattern to match [paradigm_form id="1"] shortcodes
        $pattern = '/\[paradigm_form\s+([^\]]+)\]/';
        
        return preg_replace_callback($pattern, function($matches) {
            // Parse attributes from shortcode
            $attributes = [];
            if (preg_match_all('/(\w+)="([^"]*)"/', $matches[1], $attrMatches, PREG_SET_ORDER)) {
                foreach ($attrMatches as $attr) {
                    $attributes[$attr[1]] = $attr[2];
                }
            }
            
            return $this->shortcodeService->processShortcode($attributes);
        }, $content);
    }
}
