<?php

namespace App\Http\Controllers\Provider;

use App\Http\Controllers\Controller;
use App\Models\ParadigmLinkRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ParadigmLinkRequestController extends Controller
{
    /**
     * List link requests for practitioner
     */
    public function index(Request $request)
    {
        $user = Auth::user();
        
        $query = ParadigmLinkRequest::with(['result.template', 'client.userDetail'])
            ->where('practitioner_id', $user->id);

        // Filter by status
        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        $requests = $query->orderBy('requested_at', 'desc')->paginate(20);

        return view('provider.paradigm.link-requests.index', compact('requests'));
    }

    /**
     * Accept link request
     */
    public function accept($requestId)
    {
        $user = Auth::user();
        $linkRequest = ParadigmLinkRequest::findOrFail($requestId);

        if ($linkRequest->practitioner_id != $user->id) {
            abort(403, 'Unauthorized');
        }

        if ($linkRequest->status !== 'pending') {
            return redirect()->back()->with('error', 'This request has already been responded to.');
        }

        $linkRequest->accept();

        return redirect()->back()->with('success', 'Link request accepted successfully.');
    }

    /**
     * Decline link request
     */
    public function decline($requestId)
    {
        $user = Auth::user();
        $linkRequest = ParadigmLinkRequest::findOrFail($requestId);

        if ($linkRequest->practitioner_id != $user->id) {
            abort(403, 'Unauthorized');
        }

        if ($linkRequest->status !== 'pending') {
            return redirect()->back()->with('error', 'This request has already been responded to.');
        }

        $linkRequest->decline();

        return redirect()->back()->with('success', 'Link request declined.');
    }
}

