<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CreditPackage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminParadigmSalesController extends Controller
{
    /**
     * Show the sales settings page
     */
    public function index()
    {
        // Get the Paradigm Profile package
        $package = CreditPackage::where('is_paradigm_package', true)->first();
        
        // Get transactions for this package from WalletHistory
        // Include self-purchased Paradigm Profile transactions
        $transactions = \App\Models\WalletHistory::with(['user.userDetail'])
            ->where('package_id', $package ? $package->id : 0)
            ->where('status', 'Completed') // Only show completed transactions
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('admin.paradigm.sales-settings', compact('package', 'transactions'));
    }

    /**
     * Update the sales settings
     */
    public function store(Request $request)
    {
        $request->validate([
            'credits' => 'required|numeric|min:1',
            'is_active' => 'required|boolean',
        ]);

        // Calculate Price: Credits * 17.50
        $credits = $request->credits;
        $priceZar = $credits * 17.50;
        
        // Update or create the package
        $package = CreditPackage::updateOrCreate(
            ['is_paradigm_package' => true],
            [
                'credits' => $credits,
                'base_price_zar' => $priceZar,
                'final_price_zar' => $priceZar,
                'usd_equivalent' => $priceZar / 18, // Approx exchange rate, or fetch live
                'discount_percentage' => 0,
                'discount_amount_zar' => 0,
                'is_active' => $request->is_active,
                'sort_order' => 0, // Ensure it doesn't interfere with normal packages order if possible
            ]
        );

        return redirect()->back()->with('success', 'Sales settings updated successfully.');
    }
}

