# Files Changed/Created (45 files)

## Controllers (9 files)
1. `app/Http/Controllers/Public/ParadigmSalesController.php` (NEW)
2. `app/Http/Controllers/Admin/AdminParadigmSalesController.php` (NEW)
3. `app/Http/Controllers/Admin/ParadigmPricingController.php` (MODIFIED - added transactions, package data, and marketplace pricing methods)
4. `app/Http/Controllers/UserParadigmController.php` (MODIFIED - **+4, -2**: added buyCredits method, sendParadigmInvitationNotifications, and updated buyAssessment to pass full package object)
5. `app/Http/Controllers/ParadigmPaymentController.php` (MODIFIED - added chatbotRegister method)
6. `app/Http/Controllers/Provider/ParadigmMarketplaceController.php` (MODIFIED - **+1, -1**: fixed eager loading for linkRequest in myPurchases method, updated purchase redirect to my-purchases)
7. `app/Http/Controllers/Provider/ParadigmLinkRequestController.php` (MODIFIED - **+11, -3**: updated index to show status badges instead of accept/decline buttons)
8. `app/Http/Controllers/User/ParadigmLinkRequestController.php` (MODIFIED - **+11, -3**: fixed 500 error by simplifying query and fixing view structure)
9. `app/Http/Controllers/PayFastController.php` (MODIFIED - **+580, -3**: added paradigmPaymentSuccess, createAssessmentAfterPayment, handleParadigmProfilePurchase, manualITNTrigger methods; updated successUser and cancelUser for Paradigm Profile redirects)

## Models (5 files)
9. `app/Models/CreditPackage.php` (MODIFIED - added is_paradigm_package field and cast)
10. `app/Models/ParadigmAssessmentResult.php` (MODIFIED - added marketplace fields, relationships, and methods)
11. `app/Models/ParadigmMarketplacePurchase.php` (NEW)
12. `app/Models/ParadigmLinkRequest.php` (NEW)
13. `app/Models/ParadigmPractitionerTransfer.php` (NEW)
14. `app/Models/ParadigmMarketplacePricingRule.php` (NEW)

## Routes (2 files)
15. `routes/web.php` (MODIFIED - **+54, -10**: added marketplace, link request, admin pricing routes, paradigm payment success route, manual ITN trigger route; fixed route order for my-purchases; updated my-assessments and generated-links routes to include self_purchased)
16. `routes/api.php` (MODIFIED - **+3**: filter out Paradigm Profile packages for providers in credit-packages API; added create-assessment-after-payment API route)

## Views (18 files)
17. `resources/views/front/paradigm-sales.blade.php` (NEW)
18. `resources/views/admin/paradigm/sales-settings.blade.php` (NEW)
19. `resources/views/admin/paradigm/pricing/index.blade.php` (MODIFIED - added tabs: Set Price for User Self-Purchase, User Self-Purchased Profiles, and Marketplace Pricing; updated paradigm type dropdown to show all 15 types)
20. `resources/views/user/paradigm/buy-credits.blade.php` (NEW)
21. `resources/views/user/partials/sidebar.blade.php` (MODIFIED - added Buy A Paradigm Profile and Link Requests menu)
22. `resources/views/provider/wallet-topup.blade.php` (MODIFIED - filter out Paradigm Profile packages from provider wallet topup)
23. `resources/views/provider/partials/header.blade.php` (MODIFIED - added Marketplace and Link Requests menu items)
24. `resources/views/provider/paradigm/marketplace/index.blade.php` (MODIFIED - **+3, -1**: updated filter dropdown to show all 15 paradigm types; moved script to @push('scripts') to fix jQuery loading)
25. `resources/views/provider/paradigm/marketplace/show.blade.php` (MODIFIED - **+3, -1**: moved script to @push('scripts') to fix jQuery loading)
26. `resources/views/provider/paradigm/marketplace/my-purchases.blade.php` (NEW - added null checks for result and linkRequest)
27. `resources/views/provider/paradigm/marketplace/transfer.blade.php` (MODIFIED - **+3, -1**: moved script to @push('scripts') to fix jQuery loading)
28. `resources/views/provider/paradigm/link-requests/index.blade.php` (MODIFIED - **+13, -14**: removed accept/decline buttons, added status badges showing "Waiting for Approval", "Accepted", or "Declined")
29. `resources/views/user/paradigm/link-requests/index.blade.php` (MODIFIED - **+47, -24**: fixed layout from user.user to front, added breadcrumb and sidebar structure, improved null handling, moved script to @push('scripts'))
30. `resources/views/user/paradigm/payment-success.blade.php` (NEW - **+183**: payment success page with assessment creation logic and retry mechanism)
31. `resources/views/user/paradigm/buy-assessment.blade.php` (MODIFIED - **+41, -42**: removed confirmation popup, added display of admin-set ZAR price)
32. `resources/views/user/paradigm/assessments.blade.php` (MODIFIED - **+4, -1**: updated to show "Paid" for self-purchased assessments)
33. `resources/views/provider/paradigm/payment-links.blade.php` (MODIFIED - **+4, -1**: updated to show "Paid by user" for self-purchased assessments)

## Database (7 files)
30. `database/migrations/2025_11_22_084652_add_is_paradigm_package_to_credit_packages_table.php` (NEW)
31. `database/migrations/2025_01_22_100000_add_marketplace_fields_to_paradigm_assessment_results_table.php` (NEW)
32. `database/migrations/2025_01_22_100001_create_paradigm_marketplace_purchases_table.php` (NEW)
33. `database/migrations/2025_01_22_100002_create_paradigm_link_requests_table.php` (NEW)
34. `database/migrations/2025_01_22_100003_create_paradigm_practitioner_transfers_table.php` (NEW)
35. `database/migrations/2025_01_22_100004_create_paradigm_marketplace_pricing_rules_table.php` (NEW)
36. `database/seeders/ParadigmCreditPackageSeeder.php` (NEW)

## Other (1 file)
37. `app/Http/Controllers/Public/ParadigmAssessmentController.php` (MODIFIED - added auto-listing logic for marketplace)

---

# Routes Added/Modified

## Public Routes
```php
Route::get('/buyaprofile', [\App\Http\Controllers\Public\ParadigmSalesController::class, 'index'])->name('paradigm.sales');
Route::post('/paradigm/chatbot-register', [App\Http\Controllers\ParadigmPaymentController::class, 'chatbotRegister'])->name('paradigm.payment.chatbot-register');
```

## User Routes (requires authentication)
```php
Route::get('/user/paradigm/buy-credits', [App\Http\Controllers\UserParadigmController::class, 'buyCredits'])->name('user.paradigm.buy-credits')->middleware('auc');
Route::get('/user/paradigm/buy', [App\Http\Controllers\UserParadigmController::class, 'buyAssessment'])->name('user.paradigm.buy')->middleware('auc');
Route::get('/user/paradigm/payment-success', [App\Http\Controllers\PayFastController::class, 'paradigmPaymentSuccess'])->name('user.paradigm.payment-success')->middleware('auc');
Route::get('/user/paradigm/link-requests', [\App\Http\Controllers\User\ParadigmLinkRequestController::class, 'index'])->name('user.paradigm.link-requests')->middleware('auc');
Route::post('/user/paradigm/link-requests/{requestId}/accept', [\App\Http\Controllers\User\ParadigmLinkRequestController::class, 'accept'])->name('user.paradigm.link-requests.accept')->middleware('auc');
Route::post('/user/paradigm/link-requests/{requestId}/decline', [\App\Http\Controllers\User\ParadigmLinkRequestController::class, 'decline'])->name('user.paradigm.link-requests.decline')->middleware('auc');
```

## Provider Routes (requires authentication)
**Note:** Route order is important - `my-purchases` must come before `{resultId}` to avoid route conflicts.
```php
Route::get('/provider/paradigm/marketplace', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'index'])->name('provider.paradigm.marketplace');
Route::get('/provider/paradigm/marketplace/my-purchases', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'myPurchases'])->name('provider.paradigm.marketplace.my-purchases');
Route::get('/provider/paradigm/marketplace/{resultId}', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'show'])->name('provider.paradigm.marketplace.show');
Route::post('/provider/paradigm/marketplace/{resultId}/purchase', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'purchase'])->name('provider.paradigm.marketplace.purchase');
Route::get('/provider/paradigm/marketplace/{resultId}/download', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'download'])->name('provider.paradigm.marketplace.download');
Route::get('/provider/paradigm/marketplace/{purchaseId}/transfer', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'transferProfile'])->name('provider.paradigm.marketplace.transfer');
Route::post('/provider/paradigm/marketplace/{purchaseId}/transfer', [\App\Http\Controllers\Provider\ParadigmMarketplaceController::class, 'processTransfer'])->name('provider.paradigm.marketplace.transfer.process');
Route::get('/provider/paradigm/link-requests', [\App\Http\Controllers\Provider\ParadigmLinkRequestController::class, 'index'])->name('provider.paradigm.link-requests');
Route::post('/provider/paradigm/link-requests/{requestId}/accept', [\App\Http\Controllers\Provider\ParadigmLinkRequestController::class, 'accept'])->name('provider.paradigm.link-requests.accept');
Route::post('/provider/paradigm/link-requests/{requestId}/decline', [\App\Http\Controllers\Provider\ParadigmLinkRequestController::class, 'decline'])->name('provider.paradigm.link-requests.decline');
```

## API Routes
```php
// Credit Packages API (MODIFIED - filters out Paradigm Profile packages for providers)
Route::get('/credit-packages', function() {
    // Excludes is_paradigm_package = true for providers (user_type = 2)
});

// Create Assessment After Payment API (NEW)
Route::post('/paradigm/create-assessment-after-payment', [\App\Http\Controllers\PayFastController::class, 'createAssessmentAfterPayment'])->middleware(['web', 'auth'])->name('api.paradigm.create-assessment-after-payment');
```

## Public Routes (Additional)
```php
// Manual ITN Trigger for Local Testing (NEW)
Route::post('/payfast/manual-itn-trigger', [\App\Http\Controllers\PayFastController::class, 'manualITNTrigger'])->name('payfast.manual-itn-trigger');
```

## Admin Routes (requires admin authentication)
```php
Route::get('/sales-settings', [\App\Http\Controllers\Admin\AdminParadigmSalesController::class, 'index'])->name('sales.index');
Route::post('/sales-settings', [\App\Http\Controllers\Admin\AdminParadigmSalesController::class, 'store'])->name('sales.store');

Route::prefix('pricing')->name('pricing.')->group(function () {
    Route::get('/', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'index'])->name('index');
    Route::post('/', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'store'])->name('store');
    Route::get('/{templateId}', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'show'])->name('show');
    Route::post('/toggle-status', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'toggleStatus'])->name('toggle-status');
    
    // Marketplace Pricing (NEW)
    Route::get('/marketplace', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'marketplacePricing'])->name('marketplace.index');
    Route::post('/marketplace', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'storeMarketplacePricing'])->name('marketplace.store');
    Route::delete('/marketplace/{ruleId}', [\App\Http\Controllers\Admin\ParadigmPricingController::class, 'deleteMarketplacePricing'])->name('marketplace.delete');
});
```

---

# Migration Code

Run all migrations:
```bash
php artisan migrate
```

Or run individual migrations:
```bash
php artisan migrate --path=database/migrations/2025_11_22_084652_add_is_paradigm_package_to_credit_packages_table.php
php artisan migrate --path=database/migrations/2025_01_22_100000_add_marketplace_fields_to_paradigm_assessment_results_table.php
php artisan migrate --path=database/migrations/2025_01_22_100001_create_paradigm_marketplace_purchases_table.php
php artisan migrate --path=database/migrations/2025_01_22_100002_create_paradigm_link_requests_table.php
php artisan migrate --path=database/migrations/2025_01_22_100003_create_paradigm_practitioner_transfers_table.php
php artisan migrate --path=database/migrations/2025_01_22_100004_create_paradigm_marketplace_pricing_rules_table.php
```

---

# Seeder Code

Run all seeders:
```bash
php artisan db:seed
```

Or run individual seeder:
```bash
php artisan db:seed --class=ParadigmCreditPackageSeeder
```
