<?php

use Illuminate\Support\Facades\Route;
use Modules\Leads\Http\Controllers\LeadsController;
use Modules\Leads\app\Http\Controllers\AdminPricingController;
use Modules\Leads\app\Http\Controllers\AdminMarketplaceAnalyticsController;
use Modules\Leads\app\Http\Controllers\ProviderMarketplaceController;
use Modules\Leads\app\Http\Controllers\ClientLeadController;
use Modules\Leads\app\Http\Controllers\HelpFormQuestionsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/admin/leads', function () {
    return view('leads::leads.leads');
})->name('admin.leads')->middleware('admin.auth', 'permission');

Route::get('/admin/leadsinfo', function () {
    return view('leads::leads.leadsinfo');
})->name('admin.leadsinfo')->middleware('admin.auth', 'permission');

Route::get('/admin/leads/{id}/question-responses', [HelpFormQuestionsController::class, 'getLeadResponses'])
    ->name('admin.leads.question-responses')
    ->middleware('admin.auth', 'permission');

Route::post('/admin/leads/delete', [LeadsController::class, 'deleteLead'])
    ->name('admin.leads.delete')
    ->middleware('admin.auth', 'permission');

// Admin Lead Pricing Routes
Route::prefix('admin/leads')->middleware(['admin.auth', 'permission'])->group(function () {
    Route::get('/pricing', [AdminPricingController::class, 'index'])->name('admin.leads.pricing');
    
    // Specific routes BEFORE parameterized routes
    Route::post('/pricing/list', [AdminPricingController::class, 'list'])->name('admin.leads.pricing.list');
    Route::post('/pricing/store', [AdminPricingController::class, 'store'])->name('admin.leads.pricing.store');
    Route::get('/pricing/categories/available', [AdminPricingController::class, 'getAvailableCategories'])->name('admin.leads.pricing.categories');
    Route::get('/pricing/categories/with-rules', [AdminPricingController::class, 'getCategoriesWithRules'])->name('admin.leads.pricing.categories.with-rules');
    Route::post('/pricing/template/apply', [AdminPricingController::class, 'applyTemplate'])->name('admin.leads.pricing.template');
    Route::post('/pricing/test/calculate', [AdminPricingController::class, 'testCalculation'])->name('admin.leads.pricing.test');
    
    // Parameterized routes AFTER specific routes
    Route::get('/pricing/{id}', [AdminPricingController::class, 'get'])->name('admin.leads.pricing.get')->where('id', '[0-9]+');
    Route::put('/pricing/{id}', [AdminPricingController::class, 'update'])->name('admin.leads.pricing.update')->where('id', '[0-9]+');
    Route::delete('/pricing/{id}', [AdminPricingController::class, 'destroy'])->name('admin.leads.pricing.destroy')->where('id', '[0-9]+');
    Route::post('/pricing/{id}/toggle', [AdminPricingController::class, 'toggleStatus'])->name('admin.leads.pricing.toggle')->where('id', '[0-9]+');
    
    // Admin Analytics Routes
    Route::get('/analytics', [AdminMarketplaceAnalyticsController::class, 'index'])->name('admin.leads.analytics');
    Route::get('/analytics/overview', [AdminMarketplaceAnalyticsController::class, 'getOverviewStats'])->name('admin.leads.analytics.overview');
    
    // Help Form Questions Routes
    Route::get('/help-form-questions', [HelpFormQuestionsController::class, 'index'])->name('admin.leads.help-form-questions');
    Route::post('/help-form-questions/list', [HelpFormQuestionsController::class, 'list'])->name('admin.leads.help-form-questions.list');
    Route::post('/help-form-questions', [HelpFormQuestionsController::class, 'store'])->name('admin.leads.help-form-questions.store');
    Route::get('/help-form-questions/{id}', [HelpFormQuestionsController::class, 'show'])->name('admin.leads.help-form-questions.show')->where('id', '[0-9]+');
    Route::put('/help-form-questions/{id}', [HelpFormQuestionsController::class, 'update'])->name('admin.leads.help-form-questions.update')->where('id', '[0-9]+');
    Route::delete('/help-form-questions/{id}', [HelpFormQuestionsController::class, 'destroy'])->name('admin.leads.help-form-questions.destroy')->where('id', '[0-9]+');
    Route::post('/help-form-questions/{id}/toggle-status', [HelpFormQuestionsController::class, 'toggleStatus'])->name('admin.leads.help-form-questions.toggle')->where('id', '[0-9]+');
    Route::get('/analytics/categories', [AdminMarketplaceAnalyticsController::class, 'getLeadsByCategory'])->name('admin.leads.analytics.categories');
    Route::get('/analytics/performance', [AdminMarketplaceAnalyticsController::class, 'getPerformanceOverTime'])->name('admin.leads.analytics.performance');
    Route::get('/analytics/top-providers', [AdminMarketplaceAnalyticsController::class, 'getTopProviders'])->name('admin.leads.analytics.top-providers');
    Route::get('/analytics/pricing', [AdminMarketplaceAnalyticsController::class, 'getPricingAnalytics'])->name('admin.leads.analytics.pricing');
    Route::get('/analytics/export', [AdminMarketplaceAnalyticsController::class, 'exportAnalytics'])->name('admin.leads.analytics.export');
});

// Provider Marketplace Routes
Route::prefix('provider')->middleware(['auc', 'permission'])->group(function () {
    Route::get('/marketplace', [ProviderMarketplaceController::class, 'index'])->name('provider.marketplace');
    Route::post('/marketplace/leads', [ProviderMarketplaceController::class, 'getLeads'])->name('provider.marketplace.leads');
    Route::get('/marketplace/wallet', [ProviderMarketplaceController::class, 'getWalletBalance'])->name('provider.marketplace.wallet');
    Route::post('/marketplace/unlock', [ProviderMarketplaceController::class, 'unlockLead'])->name('provider.marketplace.unlock');
    Route::post('/marketplace/unlocked', [ProviderMarketplaceController::class, 'getUnlockedLeads'])->name('provider.marketplace.unlocked');
    Route::post('/marketplace/connect', [ProviderMarketplaceController::class, 'sendConnectionRequest'])->name('provider.marketplace.connect');
});

// Client Submitted Requests Routes
Route::prefix('user')->middleware(['auth'])->group(function () {
    Route::get('/submitted-requests', [ClientLeadController::class, 'index'])->name('user.submitted-requests');
    Route::get('/linked-providers', [ClientLeadController::class, 'linkedProviders'])->name('user.linked-providers');
    Route::get('/submitted-requests/data', [MarketplaceLeadController::class, 'getUserRequests'])->name('user.submitted-requests.data');
    Route::post('/submitted-requests/list', [ClientLeadController::class, 'getMyRequests'])->name('user.submitted-requests.list');
    Route::post('/linked-providers/list', [ClientLeadController::class, 'getLinkedProvidersList'])->name('user.linked-providers.list');
    Route::get('/submitted-requests/{leadId}/providers', [ClientLeadController::class, 'getInterestedProviders'])->name('user.submitted-requests.providers');
    Route::post('/submitted-requests/accept', [ClientLeadController::class, 'acceptConnection'])->name('user.submitted-requests.accept');
    Route::post('/submitted-requests/decline', [ClientLeadController::class, 'declineConnection'])->name('user.submitted-requests.decline');
    Route::post('/submitted-requests/delink', [ClientLeadController::class, 'delinkProvider'])->name('user.submitted-requests.delink');
    Route::post('/submitted-requests/cancel', [ClientLeadController::class, 'cancelRequest'])->name('user.submitted-requests.cancel');
});

