@extends('provider.provider')

@section('title', __('Marketplace Leads'))

@push('styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables/css/jquery.dataTables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables/css/responsive.dataTables.min.css') }}">
<style>
    .lead-card {
        transition: all 0.3s ease;
        border: 1px solid #e3e6f0;
    }
    .lead-card:hover {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        transform: translateY(-2px);
    }
    .blur-content {
        filter: blur(5px);
        pointer-events: none;
    }
    .unlock-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.7);
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 0.35rem;
    }
    .wallet-balance {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 0.5rem;
        padding: 1rem;
    }
</style>
@endpush

@section('content')
<div class="page-wrapper">
    <div class="content pb-4">
        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between mb-3 pb-3 border-bottom position-relative">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Marketplace Leads') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('provider.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ __('Marketplace Leads') }}
                        </li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Wallet Balance Card -->
        <div class="row mb-4">
            <div class="col-lg-4">
                <div class="wallet-balance">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1">{{ __('Wallet Balance') }}</h6>
                            <h4 class="mb-0" id="walletBalance">0 Credits</h4>
                        </div>
                        <i class="fas fa-wallet fa-2x opacity-75"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">{{ __('Quick Stats') }}</h6>
                        <div class="row text-center">
                            <div class="col-4">
                                <div class="border-end">
                                    <h5 class="mb-1 text-primary" id="totalLeads">0</h5>
                                    <small class="text-muted">{{ __('Total Leads') }}</small>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="border-end">
                                    <h5 class="mb-1 text-success" id="unlockedLeads">0</h5>
                                    <small class="text-muted">{{ __('Unlocked') }}</small>
                                </div>
                            </div>
                            <div class="col-4">
                                <h5 class="mb-1 text-warning" id="pendingLeads">0</h5>
                                <small class="text-muted">{{ __('Pending') }}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabs -->
        <ul class="nav nav-tabs mb-4" id="marketplaceTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="available-tab" data-bs-toggle="tab" data-bs-target="#available" type="button" role="tab">
                    <i class="fas fa-store me-1"></i>{{ __('Available Leads') }}
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="unlocked-tab" data-bs-toggle="tab" data-bs-target="#unlocked" type="button" role="tab">
                    <i class="fas fa-unlock me-1"></i>{{ __('My Unlocked Leads') }}
                </button>
            </li>
        </ul>

        <div class="tab-content" id="marketplaceTabsContent">
            <!-- Available Leads Tab -->
            <div class="tab-pane fade show active" id="available" role="tabpanel">
                <!-- Filters -->
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <label class="form-label">{{ __('Category') }}</label>
                                <select class="form-select" id="categoryFilter">
                                    <option value="">{{ __('All Categories') }}</option>
                                </select>
                            </div>
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Price Range') }}</label>
                        <select class="form-select" id="priceFilter">
                            <option value="">{{ __('All Prices') }}</option>
                            <option value="0-25">0 - 25 Credits</option>
                            <option value="25-50">25 - 50 Credits</option>
                            <option value="50-100">50 - 100 Credits</option>
                            <option value="100+">100+ Credits</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Quality Score') }}</label>
                        <select class="form-select" id="qualityFilter">
                            <option value="">{{ __('All Quality') }}</option>
                            <option value="80-100">80-100 (Excellent)</option>
                            <option value="60-79">60-79 (Good)</option>
                            <option value="40-59">40-59 (Average)</option>
                            <option value="0-39">0-39 (Poor)</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Search') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="searchInput" placeholder="{{ __('Search leads...') }}">
                            <button class="btn btn-outline-secondary" type="button" id="searchBtn">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Leads Grid -->
        <div class="row" id="leadsGrid">
            <!-- Leads will be loaded here -->
        </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <nav id="paginationNav">
                        <!-- Pagination will be loaded here -->
                    </nav>
                </div>
            </div>

            <!-- Unlocked Leads Tab -->
            <div class="tab-pane fade" id="unlocked" role="tabpanel">
                <div class="row" id="unlockedLeadsGrid">
                    <!-- Unlocked leads will be loaded here -->
                </div>
                <div class="d-flex justify-content-center mt-4">
                    <nav id="unlockedPaginationNav">
                        <!-- Pagination will be loaded here -->
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Lead Details Modal -->
<div class="modal fade" id="leadDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Lead Details') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="leadDetailsContent">
                <!-- Lead details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                <button type="button" class="btn btn-primary" id="unlockLeadBtn" style="display: none;">
                    <i class="fas fa-unlock me-1"></i>{{ __('Unlock Lead') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Unlock Confirmation Modal -->
<div class="modal fade" id="unlockConfirmModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Confirm Lead Unlock') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>{{ __('Are you sure you want to unlock this lead for') }} <strong id="unlockPrice">0 Credits</strong>?</p>
                <p class="text-muted">{{ __('This action cannot be undone.') }}</p>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-1"></i>
                    {{ __('After unlocking, you will be able to see the client\'s contact information and send them a connection request.') }}
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="button" class="btn btn-primary" id="confirmUnlockBtn">
                    <i class="fas fa-unlock me-1"></i>{{ __('Unlock Lead') }}
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('assets/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/js/provider-marketplace.js') }}"></script>
@endpush
