@extends('admin.admin')

@section('title', __('Help Form Questions'))

@section('content')
<div class="page-wrapper page-settings">
    <div class="content">
        <div class="content-page-header content-page-headersplit">
            <h5>{{ __('Help Form Questions') }}</h5>
            <div class="list-btn">
                <ul>
                    <li>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addQuestionModal">
                            <i class="fa fa-plus me-2"></i>{{ __('Add Question') }}
                        </button>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Info Alert -->
        <div class="alert alert-info alert-dismissible fade show" role="alert">
            <strong><i class="fa fa-info-circle me-2"></i>{{ __('Help Form Questions') }}</strong>
            <p class="mb-0 mt-2">
                {{ __('Create dynamic questions that will appear in Step 2 of the Help Form. Users will answer these questions before providing their details.') }}
            </p>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>

        <!-- Questions List -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="questionsTable">
                                <thead>
                                    <tr>
                                        <th style="width: 5%;">{{ __('Order') }}</th>
                                        <th style="width: 40%;">{{ __('Question') }}</th>
                                        <th style="width: 15%;">{{ __('Type') }}</th>
                                        <th style="width: 10%;">{{ __('Required') }}</th>
                                        <th style="width: 10%;">{{ __('Answers') }}</th>
                                        <th style="width: 10%;">{{ __('Status') }}</th>
                                        <th style="width: 10%;">{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody id="questionsList">
                                    <!-- Loaded via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add/Edit Question Modal -->
<div class="modal fade" id="addQuestionModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="questionForm">
                <input type="hidden" id="question_id" name="question_id">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">{{ __('Add Question') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="question_text" class="form-label">{{ __('Question Text') }} *</label>
                        <textarea class="form-control" id="question_text" name="question_text" rows="2" required></textarea>
                        <div class="invalid-feedback"></div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="question_type" class="form-label">{{ __('Question Type') }} *</label>
                            <select class="form-select" id="question_type" name="question_type" required>
                                <option value="">{{ __('Select Type') }}</option>
                                <option value="radio">{{ __('Single Choice (Radio)') }}</option>
                                <option value="checkbox">{{ __('Multiple Choice (Checkbox)') }}</option>
                                <option value="select">{{ __('Dropdown (Select)') }}</option>
                                <option value="text">{{ __('Text Input') }}</option>
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">&nbsp;</label>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_required" name="is_required" checked>
                                <label class="form-check-label" for="is_required">
                                    {{ __('Required Field') }}
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- Answer Options (shown for radio/checkbox/select) -->
                    <div id="answersSection" style="display: none;">
                        <label class="form-label">{{ __('Answer Options') }} *</label>
                        <div id="answersList">
                            <!-- Dynamic answer inputs will be added here -->
                        </div>
                        <button type="button" class="btn btn-sm btn-outline-primary" id="addAnswerBtn">
                            <i class="fa fa-plus me-1"></i>{{ __('Add Answer') }}
                        </button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary" id="btnSaveQuestion">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">{{ __('Save') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src="{{ asset('assets/js/admin-help-form-questions.js') }}"></script>
@endpush

