@extends('admin.admin')

@section('title', __('Marketplace Analytics'))

@push('styles')
<style>
    .stat-card {
        transition: all 0.3s ease;
        border: 1px solid #e3e6f0;
    }
    .stat-card:hover {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        transform: translateY(-2px);
    }
    .chart-container {
        position: relative;
        height: 400px;
        margin-bottom: 2rem;
    }
    .export-buttons {
        margin-bottom: 1rem;
    }
</style>
@endpush

@section('content')
<div class="page-wrapper">
    <div class="content pb-4">
        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between mb-3 pb-3 border-bottom position-relative">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Marketplace Analytics') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.leads') }}">{{ __('Leads') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ __('Marketplace Analytics') }}
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="export-buttons">
                <div class="btn-group" role="group">
                    <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown">
                        <i class="fas fa-download me-1"></i>{{ __('Export Data') }}
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#" onclick="exportAnalytics('overview')">{{ __('Overview Report') }}</a></li>
                        <li><a class="dropdown-item" href="#" onclick="exportAnalytics('leads')">{{ __('Leads Data') }}</a></li>
                        <li><a class="dropdown-item" href="#" onclick="exportAnalytics('providers')">{{ __('Providers Data') }}</a></li>
                        <li><a class="dropdown-item" href="#" onclick="exportAnalytics('pricing')">{{ __('Pricing Data') }}</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Date Range Filter -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <label class="form-label">{{ __('Date Range') }}</label>
                        <select class="form-select" id="dateRangeFilter">
                            <option value="7">{{ __('Last 7 days') }}</option>
                            <option value="30" selected>{{ __('Last 30 days') }}</option>
                            <option value="90">{{ __('Last 90 days') }}</option>
                            <option value="365">{{ __('Last year') }}</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="refreshAnalytics">
                                <i class="fas fa-sync-alt me-1"></i>{{ __('Refresh') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Overview Stats -->
        <div class="row mb-4" id="overviewStats">
            <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                <div class="card stat-card">
                    <div class="card-body text-center">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Total Leads') }}</h6>
                                <h4 class="mb-0 text-primary" id="totalLeads">0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-file-alt fa-2x text-primary opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                <div class="card stat-card">
                    <div class="card-body text-center">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Total Revenue') }}</h6>
                                <h4 class="mb-0 text-success" id="totalRevenue">$0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-dollar-sign fa-2x text-success opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                <div class="card stat-card">
                    <div class="card-body text-center">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Total Unlocks') }}</h6>
                                <h4 class="mb-0 text-info" id="totalUnlocks">0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-unlock fa-2x text-info opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                <div class="card stat-card">
                    <div class="card-body text-center">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Active Providers') }}</h6>
                                <h4 class="mb-0 text-warning" id="activeProviders">0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-users fa-2x text-warning opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                <div class="card stat-card">
                    <div class="card-body text-center">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Conversion Rate') }}</h6>
                                <h4 class="mb-0 text-purple" id="conversionRate">0%</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-percentage fa-2x text-purple opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                <div class="card stat-card">
                    <div class="card-body text-center">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ __('Avg. Price') }}</h6>
                                <h4 class="mb-0 text-secondary" id="avgUnlockPrice">$0</h4>
                            </div>
                            <div class="flex-shrink-0">
                                <i class="fas fa-chart-line fa-2x text-secondary opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">{{ __('Performance Over Time') }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="performanceChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">{{ __('Leads by Category') }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="categoryChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Tables Row -->
        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">{{ __('Top Performing Providers') }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="topProvidersTable">
                                <thead>
                                    <tr>
                                        <th>{{ __('Provider') }}</th>
                                        <th>{{ __('Unlocks') }}</th>
                                        <th>{{ __('Total Spent') }}</th>
                                        <th>{{ __('Avg. Spent') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">{{ __('Pricing Distribution') }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="pricingTable">
                                <thead>
                                    <tr>
                                        <th>{{ __('Price Range') }}</th>
                                        <th>{{ __('Count') }}</th>
                                        <th>{{ __('Avg. Price') }}</th>
                                        <th>{{ __('Revenue') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('assets/plugins/chartjs/chart.min.js') }}"></script>
<script src="{{ asset('assets/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/js/admin-marketplace-analytics.js') }}"></script>
@endpush
