<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * SAFELY adds related_lead_id to existing wallet_history table
     * to track which wallet transactions are related to lead unlocks.
     * 
     * This is a NON-BREAKING change - only adds a new nullable field.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('wallet_history', function (Blueprint $table) {
            // Check if column doesn't already exist
            if (!Schema::hasColumn('wallet_history', 'related_lead_id')) {
                $table->unsignedBigInteger('related_lead_id')->nullable()->after('transaction_id')->comment('Lead ID if transaction is for lead unlock');
                
                // Add foreign key
                $table->foreign('related_lead_id')->references('id')->on('user_form_inputs')->onDelete('set null');
                
                // Add index for faster queries
                $table->index('related_lead_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('wallet_history', function (Blueprint $table) {
            if (Schema::hasColumn('wallet_history', 'related_lead_id')) {
                // Drop foreign key first
                $table->dropForeign(['related_lead_id']);
                
                // Drop index
                $table->dropIndex(['related_lead_id']);
                
                // Drop column
                $table->dropColumn('related_lead_id');
            }
        });
    }
};

