<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * Creates the lead_pricing_rules table for admin to configure
     * dynamic pricing based on category, fields filled, and message length.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('lead_pricing_rules', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('category_id')->unique()->comment('One pricing rule per category');
            
            // Pricing components
            $table->decimal('base_price', 10, 2)->default(10.00)->comment('Base price for this category');
            $table->decimal('price_per_field', 10, 2)->default(0.50)->comment('Additional price per field filled');
            $table->decimal('price_per_100_chars', 10, 2)->default(0.10)->comment('Additional price per 100 characters in message');
            
            // Price limits
            $table->decimal('min_price', 10, 2)->default(5.00)->comment('Minimum unlock price');
            $table->decimal('max_price', 10, 2)->default(100.00)->comment('Maximum unlock price cap');
            
            // Status
            $table->boolean('active')->default(true)->comment('Is this pricing rule active');
            
            // Audit
            $table->unsignedBigInteger('created_by_admin_id')->nullable();
            $table->unsignedBigInteger('updated_by_admin_id')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            // Foreign keys
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('created_by_admin_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by_admin_id')->references('id')->on('users')->onDelete('set null');
            
            // Indexes
            $table->index('active');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('lead_pricing_rules');
    }
};

