<?php

namespace Modules\Leads\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserHelpFormResponse extends Model
{
    use HasFactory;

    protected $fillable = [
        'lead_id',
        'question_id',
        'answer_id',
        'answer_text',
    ];

    /**
     * Get the lead this response belongs to
     */
    public function lead(): BelongsTo
    {
        return $this->belongsTo(UserFormInput::class, 'lead_id');
    }

    /**
     * Get the question
     */
    public function question(): BelongsTo
    {
        return $this->belongsTo(HelpFormQuestion::class, 'question_id');
    }

    /**
     * Get the selected answer
     */
    public function answer(): BelongsTo
    {
        return $this->belongsTo(HelpFormAnswer::class, 'answer_id');
    }
}

