<?php

namespace Modules\Leads\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class HelpFormQuestion extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'question_text',
        'question_type',
        'order',
        'is_active',
        'is_required',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_required' => 'boolean',
    ];

    /**
     * Get the answers for this question
     */
    public function answers(): HasMany
    {
        return $this->hasMany(HelpFormAnswer::class, 'question_id');
    }

    /**
     * Get responses for this question
     */
    public function responses(): HasMany
    {
        return $this->hasMany(UserHelpFormResponse::class, 'question_id');
    }
}

