<?php

use Illuminate\Support\Facades\Route;
use Modules\Communication\app\Http\Controllers\CommunicationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great.
|
*/

Route::group([], function () {
    Route::post('/otp-settings', [CommunicationController::class, 'getOtpSettings']);
    Route::post('/verify-otp', [CommunicationController::class, 'verifyOtp']);
    Route::post('/register-otp-settings', [CommunicationController::class, 'getRegisterOtpSettings']);
    Route::post('/provider-register-otp-settings', [CommunicationController::class, 'getProviderRegisterOtpSettings']);
    Route::post('/register-verify-otp', [CommunicationController::class, 'verifyRegisterOtp']);
});

// Notification routes removed - Firebase/push notifications disabled
